<?php

namespace Motors_E_W\Pro\Widgets\SingleListing;

use Motors_E_W\MotorsApp;
use STM_E_W\Helpers\Helper;
use STM_E_W\Widgets\Controls\ContentControls\HeadingControl;
use STM_E_W\Widgets\Controls\ContentControls\IconsControl;
use STM_E_W\Widgets\Controls\ContentControls\SwitcherControl;
use STM_E_W\Widgets\Controls\ContentControls\NumberControl;
use STM_E_W\Widgets\Controls\StyleControls\ColorControl;
use STM_E_W\Widgets\Controls\StyleControls\GroupTypographyControl;
use STM_E_W\Widgets\Controls\StyleControls\SliderControl;
use Motors_E_W\Pro\Widgets\WidgetBase;

class GalleryCarousel extends WidgetBase {

	use SwitcherControl, NumberControl, GroupTypographyControl, SliderControl, HeadingControl, ColorControl, IconsControl;

	public function __construct( array $data = array(), array $args = null ) {
		parent::__construct( $data, $args );

		$this->stm_ew_admin_register_ss( $this->get_admin_name(), self::get_name(), MOTORS_ELEMENTOR_WIDGETS_PATH, MOTORS_ELEMENTOR_WIDGETS_URL, MOTORS_ELEMENTOR_WIDGETS_PLUGIN_VERSION );
		$this->stm_ew_enqueue(
			self::get_name(),
			MOTORS_ELEMENTOR_WIDGETS_PATH,
			MOTORS_ELEMENTOR_WIDGETS_URL,
			MOTORS_ELEMENTOR_WIDGETS_PLUGIN_VERSION,
			array(
				'jquery',
				'swiper',
				'elementor-frontend',
			)
		);
	}

	public function get_script_depends(): array {
		$depends   = parent::get_script_depends();
		$depends[] = 'swiper';

		return $depends;
	}

	public function get_style_depends(): array {
		$widget_styles   = parent::get_style_depends();
		$widget_styles[] = 'swiper';

		return $widget_styles;
	}

	public function get_categories() {
		return array( MotorsApp::WIDGET_CATEGORY_SINGLE );
	}

	public function get_name() {
		return MotorsApp::STM_PREFIX . '-single-listing-gallery-carousel';
	}

	public function get_title() {
		return esc_html__( 'Gallery Carousel', 'motors-elementor-widgets' );
	}

	public function get_icon() {
		return 'eicon-slider-push';
	}

	protected function register_controls() {

		$this->stm_start_content_controls_section( 'Media', esc_html__( 'Media', 'motors-elementor-widgets' ) );

		$this->stm_ew_add_switcher(
			'include_video',
			array(
				'label'   => esc_html__( 'Include videos', 'motors-elementor-widgets' ),
				'default' => 'yes',
			)
		);

		$this->stm_end_control_section();

		$this->stm_start_content_controls_section( 'Labels', esc_html__( 'Labels', 'motors-elementor-widgets' ) );

		$this->stm_ew_add_switcher(
			'show_sold_label',
			array(
				'label'   => esc_html__( 'Show Sold label', 'motors-elementor-widgets' ),
				'default' => 'yes',
			)
		);

		$this->stm_end_control_section();

		$this->stm_start_content_controls_section( 'Slider', esc_html__( 'Slider', 'motors-elementor-widgets' ) );

		$this->stm_ew_add_switcher(
			'stretch',
			array(
				'label'       => esc_html__( 'Stretch Carousel', 'motors-elementor-widgets' ),
				'description' => esc_html__( 'Will take effect when listing has more than 2 medias to display', 'motors-elementor-widgets' ),
				'default'     => '',
			),
		);

		$this->stm_ew_add_switcher(
			'navigation',
			array(
				'label'   => esc_html__( 'Previous/Next Buttons', 'motors-elementor-widgets' ),
				'default' => 'yes',
			),
		);

		$this->stm_ew_add_switcher(
			'loop',
			array(
				'label'   => esc_html__( 'Infinite Loop', 'motors-elementor-widgets' ),
				'default' => 'yes',
			)
		);

		$this->stm_ew_add_number(
			'transition_speed',
			array(
				'label'       => esc_html__( 'Animation Speed', 'motors-elementor-widgets' ),
				'min'         => 100,
				'step'        => 100,
				'default'     => 400,
				'description' => __( 'Speed of slide animation in milliseconds', 'motors-elementor-widgets' ),
			)
		);

		$this->stm_ew_add_switcher(
			'autoplay',
			array(
				'label'   => esc_html__( 'Autoplay', 'motors-elementor-widgets' ),
				'default' => 'yes',
			)
		);

		$this->stm_ew_add_number(
			'delay',
			array(
				'label'       => esc_html__( 'Slide Duration', 'motors-elementor-widgets' ),
				'min'         => 100,
				'step'        => 100,
				'default'     => 3000,
				'condition'   => array(
					'autoplay' => 'yes',
				),
				'description' => esc_html__( 'Delay between transitions in milliseconds', 'motors-elementor-widgets' ),
			)
		);

		$this->stm_ew_add_switcher(
			'pause_on_mouseover',
			array(
				'label'       => esc_html__( 'Pause on Mouseover', 'motors-elementor-widgets' ),
				'condition'   => array(
					'autoplay' => 'yes',
				),
				'description' => esc_html__( 'When enabled autoplay will be paused on mouse enter over carousel container', 'motors-elementor-widgets' ),
			)
		);

		$this->stm_end_control_section();

		$this->stm_start_content_controls_section( 'Action buttons', esc_html__( 'Actions', 'motors-elementor-widgets' ) );

		$this->stm_ew_add_switcher(
			'show_print',
			array(
				'label'   => esc_html__( 'Print', 'motors-elementor-widgets' ),
				'default' => '',
			)
		);

		$this->stm_ew_add_switcher(
			'show_compare',
			array(
				'label'   => esc_html__( 'Compare', 'motors-elementor-widgets' ),
				'default' => '',
			)
		);

		$this->stm_ew_add_switcher(
			'show_share',
			array(
				'label'   => esc_html__( 'Share', 'motors-elementor-widgets' ),
				'default' => '',
			)
		);

		if ( apply_filters( 'is_listing', array() ) ) {
			$this->stm_ew_add_switcher(
				'show_featured',
				array(
					'label'   => esc_html__( 'Favorite', 'motors-elementor-widgets' ),
					'default' => '',
				)
			);
		}

		$this->stm_ew_add_switcher(
			'show_test_drive',
			array(
				'label'   => esc_html__( 'Test Drive', 'motors-elementor-widgets' ),
				'default' => '',
			)
		);

		$this->stm_ew_add_switcher(
			'show_pdf',
			array(
				'label'   => esc_html__( 'PDF', 'motors-elementor-widgets' ),
				'default' => '',
			)
		);

		$this->stm_end_control_section();

		$this->stm_start_style_controls_section( 'style', esc_html__( 'Style', 'motors-elementor-widgets' ) );

		$this->stm_ew_add_heading(
			'featured_heading',
			array(
				'label' => esc_html__( 'Featured listing label', 'motors-elementor-widgets' ),
			),
		);

		$this->stm_ew_add_group_typography(
			'featured_label_typography',
			array(
				'label'          => esc_html__( 'Label typography', 'motors-elementor-widgets' ),
				'exclude'        => array(
					'line_height',
					'text_transform',
					'text_decoration',
					'word_spacing',
				),
				'fields_options' => array(
					'font_size' => array(
						'size_units' => array(
							'px',
							'em',
						),
						'default'    => array(
							'unit' => 'px',
							'size' => 12,
						),
					),
				),
				'selector'       => '{{WRAPPER}} .stm-gallery-listing-info .special-label-inline',
			),
		);

		$this->stm_ew_add_icons(
			'featured_icon',
			array(
				'label'            => esc_html__( 'Icon', 'motors-elementor-widgets' ),
				'skin'             => 'inline',
				'fa4compatibility' => 'icon',
				'default'          => array(
					'value'   => 'fas fa-crown',
					'library' => 'fa-solid',
				),
			)
		);

		$this->stm_ew_add_slider(
			'featured_icon_size',
			array(
				'label'      => __( 'Icon Size', 'motors-elementor-widgets' ),
				'size_units' => array(
					'px',
				),
				'range'      => array(
					'px' => array(
						'min'  => 5,
						'max'  => 30,
						'step' => 1,
					),
				),
				'default'    => array(
					'size' => 12,
					'unit' => 'px',
				),
				'selectors'  => array(
					'{{WRAPPER}} .stm-gallery-listing-info .special-label-inline i'   => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .stm-gallery-listing-info .special-label-inline svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->stm_ew_add_color(
			'featured_color',
			array(
				'label'     => __( 'Color', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .stm-gallery-listing-info .special-label-inline' => 'color: {{VALUE}};',
				),
			),
		);

		$this->stm_ew_add_heading(
			'carousel_style_heading',
			array(
				'label' => esc_html__( 'Carousel', 'motors-elementor-widgets' ),
			),
		);

		$this->stm_ew_add_color(
			'carousel_nav_color',
			array(
				'label'     => __( 'Navigation Arrow Color', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .listing-gallery-carousel-nav-prev:before' => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .listing-gallery-carousel-nav-next:before' => 'border-color: {{VALUE}};',
				),
			),
		);

		$this->stm_end_control_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		Helper::stm_ew_load_template( 'pro/widgets/single-listing/gallery-carousel', MOTORS_ELEMENTOR_WIDGETS_PATH, $settings );
	}

	protected function content_template() {
	}
}
